package com.yd.product.feign.request.announcementcommissionratio;

import com.yd.product.feign.dto.ApiAnnouncementCommissionRatioBatchSaveDto;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
public class ApiAnnouncementCommissionRatioBatchSaveRequest {

    /**
     * 公告佣比率规格表唯一业务ID
     */
    @NotBlank(message = "公告佣比率规格表唯一业务ID不能为空")
    private String announcementSpeciesBizId;

    /**
     * 公告佣比率规格明细列表
     */
    @NotEmpty(message = "公告佣比率规格明细列表不能为空")
    private List<ApiAnnouncementCommissionRatioBatchSaveDto> ratioBatchSaveDtoList;
}
