package com.yd.product.feign.request.expectedspecies;

import com.yd.common.dto.PageDto;
import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class ApiExpectedSpeciesPageRequest extends PageDto {

    /**
     * 产品上架信息表唯一业务ID
     */
    @NotBlank(message = "产品上架信息表唯一业务ID不能为空")
    private String productLaunchBizId;

    /**
     * 保障计划（0-64岁等）(固定规格条件)
     */
    private String protectionPlan;

    /**
     * 供款年期（5、10、20年期等）(固定规格条件)
     */
    private String paymentTerm;
}
