package com.yd.product.feign.response.expectedcommissionratio;

import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class ApiExpectedCommissionRatioPageResponse {

    /**
     * 来佣比率规格明细表主键ID
     */
    private Long id;

    /**
     * 来佣比率规格明细表唯一业务ID
     */
    private String expectedCommissionRatioBizId;

    /**
     * 来佣比率规格表唯一业务ID
     */
    private String expectedSpeciesBizId;

    /**
     * 费用名称（转介费等）
     */
    private String expenseName;

    /**
     * 佣金年限（起）
     */
    private String startPeriod;

    /**
     * 佣金年限（止）
     */
    private String endPeriod;

    /**
     * 标保折算比例（基本保费）
     */
    private BigDecimal discountRatio;

    /**
     * 计算基数（保费/保费*折算比例）
     */
    private BigDecimal cardinalNumber;

    /**
     * 佣金率
     */
    private BigDecimal commissionRate;

    /**
     * 有效开始时间
     */
    private LocalDateTime effectiveStart;

    /**
     * 有效结束时间
     */
    private LocalDateTime effectiveEnd;

    /**
     * 是否受汇率影响 0-否 1-是，字典）
     */
    private String isExchangeRate;

    /**
     * 结算币种（字典）
     */
    private String currency;

    /**
     * 对账公司
     */
    private String reconciliationCompany;

    /**
     * 销售组织
     */
    private String salesOrg;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 创建人名称
     */
    private String creatorName;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 更新人名称
     */
    private String updaterName;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
