package com.yd.product.feign.client.productlaunch;

import com.yd.common.result.Result;
import com.yd.product.feign.fallback.productlaunch.ApiProductLaunchFeignFallbackFactory;
import com.yd.product.feign.request.productlaunch.*;
import com.yd.product.feign.response.productlaunch.ApiProductLaunchCategoryAddResponse;
import com.yd.product.feign.response.productlaunch.ApiProductLaunchDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

/**
 * 产品服务-产品上架信息Feign客户端
 */
@FeignClient(name = "yd-product-api", fallbackFactory = ApiProductLaunchFeignFallbackFactory.class)
public interface ApiProductLaunchFeignClient {

    /**
     * 分页列表查询-产品上架信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiProductLaunchPageRequest request);

    /**
     * 添加-产品上架类目信息
     * @param request
     * @return
     */
    @PostMapping("/add/category")
    Result<ApiProductLaunchCategoryAddResponse> addCategory(@Validated @RequestBody ApiProductLaunchCategoryAddRequest request);

    /**
     * 详情-产品上架信息
     * @param productLaunchBizId 产品上架信息表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiProductLaunchDetailResponse> detail(@NotBlank(message = "产品上架信息表唯一业务ID唯一业务ID能为空") @RequestParam(value = "productLaunchBizId") String productLaunchBizId);

    /**
     * 保存-产品上架信息
     * @param request
     * @return
     */
    @PostMapping("/save")
    Result save(@Validated @RequestBody ApiProductLaunchSaveRequest request);

    /**
     * 审核-产品上架信息
     * @param request
     * @return
     */
    @PutMapping("/approval")
    Result approval(@Validated @RequestBody ApiProductLaunchApprovalRequest request);

    /**
     * 编辑-产品上架状态
     * @param request
     * @return
     */
    @PutMapping("/edit/status")
    Result editStatus(@Validated @RequestBody ApiProductLaunchEditStatusRequest request);
}
