package com.yd.product.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.product.api.service.ApiAnnouncementSpeciesService;
import com.yd.product.feign.client.announcementspecies.ApiAnnouncementSpeciesFeignClient;
import com.yd.product.feign.request.announcementspecies.ApiAnnouncementSpeciesImportRequest;
import com.yd.product.feign.request.announcementspecies.ApiAnnouncementSpeciesPageRequest;
import com.yd.product.feign.response.announcementspecies.ApiAnnouncementSpeciesPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 公告佣比率规格信息
 *
 * @author zxm
 * @since 2025-12-01
 */
@RestController
@RequestMapping("/announcementSpecies")
@Validated
public class ApiAnnouncementSpeciesController implements ApiAnnouncementSpeciesFeignClient {

    @Autowired
    private ApiAnnouncementSpeciesService apiAnnouncementSpeciesService;

    /**
     * 分页列表查询-公告佣比率规格信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiAnnouncementSpeciesPageResponse>> page(ApiAnnouncementSpeciesPageRequest request) {
        return apiAnnouncementSpeciesService.page(request);
    }

    /**
     * 导入规格数据
     * @param request
     * @return
     */
    @Override
    public Result importSpecies(ApiAnnouncementSpeciesImportRequest request) {
        return apiAnnouncementSpeciesService.importSpecies(request);
    }

    /**
     * 删除规格数据 TODO
     * @param announcementSpeciesBizId
     * @return
     */
    @Override
    public Result delSpecies(String announcementSpeciesBizId) {
        return null;
    }
}
