package com.yd.product.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.base.feign.client.relobjectcategory.ApiRelObjectCategoryFeignClient;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryQueryRequest;
import com.yd.base.feign.response.relobjectcategory.ApiRelObjectCategoryQueryResponse;
import com.yd.common.result.Result;
import com.yd.oss.feign.client.ApiOssFileFeignClient;
import com.yd.oss.feign.request.ApiOssFileListRequest;
import com.yd.oss.feign.response.ApiOssFileListResponse;
import com.yd.product.api.service.ApiAttributeSettingService;
import com.yd.product.api.service.ApiRelProjectProductLaunchService;
import com.yd.product.api.service.ApiSpeciesPriceService;
import com.yd.product.api.service.ApiSpeciesSettingService;
import com.yd.product.feign.dto.ApiSpeciesPriceDto;
import com.yd.product.feign.dto.ApiSpeciesTypeDto;
import com.yd.product.feign.request.productlaunch.ApiProductLaunchParameterPageRequest;
import com.yd.product.feign.request.relprojectproductlaunch.ApiRelProjectProductLaunchPageRequest;
import com.yd.product.feign.response.productlaunch.ApiAttributeSettingDto;
import com.yd.product.feign.response.relprojectproductlaunch.ApiProductLaunchParameterPageResponse;
import com.yd.product.feign.response.relprojectproductlaunch.ApiRelProjectProductLaunchPageResponse;
import com.yd.product.service.dto.AttributeSettingDto;
import com.yd.product.service.model.AttributeSetting;
import com.yd.product.service.service.IAttributeSettingService;
import com.yd.product.service.service.IRelProjectProductLaunchService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiRelProjectProductLaunchServiceImpl implements ApiRelProjectProductLaunchService {

    @Autowired
    private IRelProjectProductLaunchService iRelProjectProductLaunchService;

    @Autowired
    private ApiAttributeSettingService apiAttributeSettingService;

    @Autowired
    private ApiSpeciesSettingService apiSpeciesSettingService;

    @Autowired
    private ApiSpeciesPriceService apiSpeciesPriceService;

    @Autowired
    private ApiRelObjectCategoryFeignClient apiRelObjectCategoryFeignClient;

    @Autowired
    private ApiOssFileFeignClient apiOssFileFeignClient;

    @Autowired
    private IAttributeSettingService iAttributeSettingService;

    /**
     * 分页列表查询-租户项目产品上架关系信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelProjectProductLaunchPageResponse>> page(ApiRelProjectProductLaunchPageRequest request) {
        Page<ApiRelProjectProductLaunchPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelProjectProductLaunchPageResponse> iPage = iRelProjectProductLaunchService.page(page, request);
        if (!CollectionUtils.isEmpty(iPage.getRecords())) {
            List<ApiRelProjectProductLaunchPageResponse> responses = iPage.getRecords();
            List<String> productLaunchBizIdList = responses.stream()
                    .map(ApiRelProjectProductLaunchPageResponse::getProductLaunchBizId)
                    .collect(Collectors.toList());
            //查询-对象分类关系列表
            ApiRelObjectCategoryQueryRequest queryRequest = new ApiRelObjectCategoryQueryRequest();
            queryRequest.setObjectBizIdList(productLaunchBizIdList);
            Result<List<ApiRelObjectCategoryQueryResponse>> result = apiRelObjectCategoryFeignClient.query(queryRequest);
            List<ApiRelObjectCategoryQueryResponse> categoryQueryResponses = result.getData();

            ApiOssFileListRequest fileListRequest = new ApiOssFileListRequest();
            fileListRequest.setObjectBizIdList(productLaunchBizIdList);
            Result<List<ApiOssFileListResponse>> listResult = apiOssFileFeignClient.list(fileListRequest);
            List<ApiOssFileListResponse> fileListResponses = listResult.getData();

            for (ApiRelProjectProductLaunchPageResponse response : responses) {
                //设置的产品上架信息的参数列表
                List<ApiAttributeSettingDto> apiAttributeSettingDtoList = apiAttributeSettingService.queryAttributeSettingDtoList(response.getProductLaunchBizId());
                response.setApiAttributeSettingDtoList(apiAttributeSettingDtoList);

                //规格信息配置列表
                // 规格信息配置列表 - 按规格类型分组
                List<ApiSpeciesTypeDto> apiSpeciesTypeDtoList = apiSpeciesSettingService.querySpeciesTypeDtoList(response.getProductLaunchBizId());
                response.setApiSpeciesTypeDtoList(apiSpeciesTypeDtoList);

                //规格价格配置列表
                List<ApiSpeciesPriceDto> apiSpeciesPriceDtoList = apiSpeciesPriceService.querySpeciesPriceDtoList(response.getProductLaunchBizId());
                response.setApiSpeciesPriceDtoList(apiSpeciesPriceDtoList);

                //设置分类列表（产品险种列表）
                if (!CollectionUtils.isEmpty(categoryQueryResponses)) {
                    List<ApiRelObjectCategoryQueryResponse> categoryQueryResponseList = categoryQueryResponses
                            .stream()
                            .filter(dto -> dto.getObjectBizId().equals(response.getProductLaunchBizId()))
                            .collect(Collectors.toList());
                    response.setCategoryQueryResponseList(categoryQueryResponseList);
                }

                //设置产品文件列表
                if (!CollectionUtils.isEmpty(fileListResponses)) {
                    List<ApiOssFileListResponse> fileListResponseList = fileListResponses
                            .stream()
                            .filter(dto -> dto.getObjectBizId().equals(response.getProductLaunchBizId()))
                            .collect(Collectors.toList());
                    response.setFileListResponseList(fileListResponseList);
                }
            }
            iPage.setRecords(responses);
        }
        return Result.success(iPage);
    }

    /**
     * 产品参数字段-分页列表查询-租户项目产品上架关系信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiProductLaunchParameterPageResponse>> parameterPage(ApiProductLaunchParameterPageRequest request) {
        Page<ApiProductLaunchParameterPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());

        // 构建最终的 productLaunchBizIdList
        List<String> finalProductLaunchBizIdList = new ArrayList<>();

        // 如果 request 中已有 productLaunchBizIdList，先加入
        if (!CollectionUtils.isEmpty(request.getProductLaunchBizIdList())) {
            finalProductLaunchBizIdList.addAll(request.getProductLaunchBizIdList());
        }

        // 根据分类编码列表查询产品上架ID
        if (!CollectionUtils.isEmpty(request.getCategoryCodeList())) {
            ApiRelObjectCategoryQueryRequest categoryQueryRequest = new ApiRelObjectCategoryQueryRequest();
            categoryQueryRequest.setCategoryCodeList(request.getCategoryCodeList());
            Result<List<ApiRelObjectCategoryQueryResponse>> categoryResult = apiRelObjectCategoryFeignClient.query(categoryQueryRequest);

            if (categoryResult != null && !CollectionUtils.isEmpty(categoryResult.getData())) {
                List<String> categoryProductLaunchIds = categoryResult.getData().stream()
                        .map(ApiRelObjectCategoryQueryResponse::getObjectBizId)
                        .distinct()
                        .collect(Collectors.toList());
                finalProductLaunchBizIdList.addAll(categoryProductLaunchIds);
            }
        }

        // 根据保险公司ID列表查询产品上架ID
        if (!CollectionUtils.isEmpty(request.getInsuranceCompanyBizIdList())) {
            List<AttributeSetting> attributeSettingList = iAttributeSettingService.queryList(AttributeSettingDto.builder()
                    .fieldValueBizIdList(request.getInsuranceCompanyBizIdList())
                    .build());

            if (!CollectionUtils.isEmpty(attributeSettingList)) {
                List<String> insuranceProductLaunchIds = attributeSettingList.stream()
                        .map(AttributeSetting::getProductLaunchBizId)
                        .distinct()
                        .collect(Collectors.toList());
                finalProductLaunchBizIdList.addAll(insuranceProductLaunchIds);
            }
        }

        // 去重并设置回 request
        if (!CollectionUtils.isEmpty(finalProductLaunchBizIdList)) {
            request.setProductLaunchBizIdList(finalProductLaunchBizIdList.stream()
                    .distinct()
                    .collect(Collectors.toList()));
        }

        // 执行查询
        IPage<ApiProductLaunchParameterPageResponse> iPage = iRelProjectProductLaunchService.parameterPage(page, request);
        if (!CollectionUtils.isEmpty(iPage.getRecords())) {
            List<ApiProductLaunchParameterPageResponse> responses = iPage.getRecords();
            List<String> productLaunchBizIdList = responses.stream()
                    .map(ApiProductLaunchParameterPageResponse::getProductLaunchBizId)
                    .collect(Collectors.toList());
            //查询-对象分类关系列表
            ApiRelObjectCategoryQueryRequest queryRequest = new ApiRelObjectCategoryQueryRequest();
            queryRequest.setObjectBizIdList(productLaunchBizIdList);
            Result<List<ApiRelObjectCategoryQueryResponse>> result = apiRelObjectCategoryFeignClient.query(queryRequest);
            List<ApiRelObjectCategoryQueryResponse> categoryQueryResponses = result.getData();

            for (ApiProductLaunchParameterPageResponse response : responses) {
                //设置的产品上架信息的参数列表
                List<ApiAttributeSettingDto> apiAttributeSettingDtoList = apiAttributeSettingService.queryAttributeSettingDtoList(response.getProductLaunchBizId());
                response.setApiAttributeSettingDtoList(apiAttributeSettingDtoList);

                //规格信息配置列表
                // 规格信息配置列表 - 按规格类型分组
                List<ApiSpeciesTypeDto> apiSpeciesTypeDtoList = apiSpeciesSettingService.querySpeciesTypeDtoList(response.getProductLaunchBizId());
                response.setApiSpeciesTypeDtoList(apiSpeciesTypeDtoList);

                //规格价格配置列表
                List<ApiSpeciesPriceDto> apiSpeciesPriceDtoList = apiSpeciesPriceService.querySpeciesPriceDtoList(response.getProductLaunchBizId());
                response.setApiSpeciesPriceDtoList(apiSpeciesPriceDtoList);

                //设置分类列表（产品险种列表）
                if (!CollectionUtils.isEmpty(categoryQueryResponses)) {
                    List<ApiRelObjectCategoryQueryResponse> categoryQueryResponseList = categoryQueryResponses
                            .stream()
                            .filter(dto -> dto.getObjectBizId().equals(response.getProductLaunchBizId()))
                            .collect(Collectors.toList());
                    response.setCategoryQueryResponseList(categoryQueryResponseList);
                }
            }
            iPage.setRecords(responses);
        }
        return Result.success(iPage);
    }
}
