package com.yd.product.feign.fallback.relprojectproductlaunch;

import com.yd.common.result.Result;
import com.yd.product.feign.client.relprojectproductlaunch.ApiRelProjectProductLaunchFeignClient;
import com.yd.product.feign.request.relprojectproductlaunch.ApiRelProjectProductLaunchPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 产品服务-项目产品上架关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelProjectProductLaunchFeignFallbackFactory implements FallbackFactory<ApiRelProjectProductLaunchFeignClient> {
    @Override
    public ApiRelProjectProductLaunchFeignClient create(Throwable cause) {
        return new ApiRelProjectProductLaunchFeignClient() {
            @Override
            public Result page(ApiRelProjectProductLaunchPageRequest request) {
                return null;
            }
        };
    }
}
