package com.yd.product.feign.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.yd.product.feign.utils.CustomLocalDateTimeDeserializer;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class ApiExpectedCommissionRatioBatchSaveDto {

    /**
     * 费用名称（转介费等）
     */
    @NotBlank(message = "费用名称（转介费等）不能为空")
    private String expenseName;

    /**
     * 佣金年限（起）
     */
    @NotBlank(message = "佣金年限（起）不能为空")
    private String startPeriod;

    /**
     * 佣金年限（止）
     */
    @NotBlank(message = "佣金年限（止）不能为空")
    private String endPeriod;

    /**
     * 标保折算比例（基本保费）
     */
    @NotNull(message = "标保折算比例（基本保费）不能为空")
    private BigDecimal discountRatio;

    /**
     * 佣金率
     */
    @NotNull(message = "佣金率不能为空")
    private BigDecimal commissionRate;

    /**
     * 有效开始时间
     */
    @JsonDeserialize(using = CustomLocalDateTimeDeserializer.class)
    @JsonFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "有效开始时间不能为空")
    private LocalDateTime effectiveStart;

    /**
     * 有效结束时间
     */
    @JsonDeserialize(using = CustomLocalDateTimeDeserializer.class)
    @JsonFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "有效结束时间不能为空")
    private LocalDateTime effectiveEnd;


    /**
     * 是否受汇率影响 0-否 1-是，字典）
     */
    @NotBlank(message = "是否受汇率影响不能为空")
    private String isExchangeRate;

    /**
     * 结算币种（字典）
     */
    @NotBlank(message = "结算币种不能为空")
    private String currency;

    /**
     * 对账公司
     */
    private String reconciliationCompany;

    /**
     * 销售组织
     */
    private String salesOrg;

    /**
     * 状态(0:停用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;
}
