package com.yd.oss.feign.response;

import lombok.Data;

import java.time.LocalDateTime;

@Data
public class ApiOssFileListResponse {

    /**
     * 文件元数据表主键ID
     */
    private Long id;

    /**
     * 对象类型
     */
    private String objectType;

    /**
     * 对象所属表名（预约表、新单跟进表等）
     */
    private String objectTableName;

    /**
     * 对象名
     */
    private String objectName;

    /**
     * 对象业务ID
     */
    private String objectBizId;

    /**
     * 文件元数据表唯一业务ID
     */
    private String fileBizId;

    /**
     * 文件唯一标识
     */
    private String fileKey;

    /**
     * 原始文件名
     */
    private String originalName;

    /**
     * 文件大小(字节)
     */
    private Long fileSize;

    /**
     * 文件类型
     */
    private String fileType;

    /**
     * 完整文件路径
     */
    private String fileUrl;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 创建人名
     */
    private String creatorName;
}
