package com.yd.oss.feign.fallback;

import com.yd.common.result.Result;
import com.yd.oss.feign.client.ApiRelObjectMaterialFeignClient;
import com.yd.oss.feign.request.ApiRelObjectMaterialListAddRequest;
import com.yd.oss.feign.request.ApiRelObjectMaterialPageRequest;
import com.yd.oss.feign.request.ApiRelObjectMaterialUploadSubmitRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 对象材料关系表信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelObjectMaterialFeignFallbackFactory implements FallbackFactory<ApiRelObjectMaterialFeignClient> {
    @Override
    public ApiRelObjectMaterialFeignClient create(Throwable cause) {
        return new ApiRelObjectMaterialFeignClient() {
            @Override
            public Result page(ApiRelObjectMaterialPageRequest request) {
                return null;
            }

            @Override
            public Result del(String relObjectMaterialBizId) {
                return null;
            }

            @Override
            public Result addRelObjectMaterialList(ApiRelObjectMaterialListAddRequest request) {
                return null;
            }

            @Override
            public Result submit(ApiRelObjectMaterialUploadSubmitRequest request) {
                return null;
            }
        };
    }
}
