package com.yd.oss.feign.fallback;

import com.yd.common.result.Result;
import com.yd.oss.feign.client.ApiExcelFeignClient;
import com.yd.oss.feign.dto.ExportResult;
import com.yd.oss.feign.request.ApiExportRequest;
import com.yd.oss.feign.request.ApiOssExcelParseRequest;
import com.yd.oss.feign.request.ApiOssExportAppointmentExcelRequest;
import com.yd.oss.feign.response.ApiOssExcelParseResponse;
import com.yd.oss.feign.response.ApiOssExportAppointmentExcelResponse;
import com.yd.oss.feign.result.ImportResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

/**
 * Excel信息Feign降级处理
 */
@Slf4j
@Component
public class ApiExcelFeignFallbackFactory implements FallbackFactory<ApiExcelFeignClient> {
    @Override
    public ApiExcelFeignClient create(Throwable cause) {
        return new ApiExcelFeignClient() {
            @Override
            public Result<ApiOssExportAppointmentExcelResponse> exportAppointment(ApiOssExportAppointmentExcelRequest request) {
                return null;
            }

            @Override
            public Result<ApiOssExcelParseResponse> parse(MultipartFile file, String[] sheetClassNames) {
                return null;
            }

            @Override
            public Result<ExportResult> export(ApiExportRequest request) {
                return null;
            }

            @Override
            public Result<ImportResult> importExcel(MultipartFile file, Integer headerRow,
                                                    Integer dataStartRow, String requiredFields) {
                return null;
            }

            @Override
            public Result<ImportResult> simpleImport(MultipartFile file) {
                return null;
            }

        };
    }
}
