package com.yd.oss.service.dto;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * 提供OSS上传文件返回的DTO
 */
@Data
public class OssUploadFileResDto {

    /**
     * 文件元数据表业务ID唯一标识
     */
    private String fileBizId;

    /**
     * 文件唯一标识
     */
    private String fileKey;

    /**
     * 原始文件名
     */
    private String originalName;

    /**
     * 完整的访问路径
     */
    private String url;

    /**
     * 访问URL（带过期时间签名URL）
     */
    private String accessUrl;

    /**
     * 文件大小
     */
    private Long fileSize;

    /**
     * 文件类型
     */
    private String fileType;

    /**
     * 上传时间
     */
    private LocalDateTime uploadTime;
}
