package com.yd.oss.feign.fallback;

import com.yd.common.result.Result;
import com.yd.oss.feign.client.ApiMaterialFeignClient;
import com.yd.oss.feign.request.ApiMaterialListRequest;
import com.yd.oss.feign.response.ApiMaterialListResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 材料基础信息Feign降级处理
 */
@Slf4j
@Component
public class ApiMaterialFeignFallbackFactory implements FallbackFactory<ApiMaterialFeignClient> {
    @Override
    public ApiMaterialFeignClient create(Throwable cause) {
        return new ApiMaterialFeignClient() {
            @Override
            public Result<List<ApiMaterialListResponse>> list(ApiMaterialListRequest request) {
                return null;
            }
        };
    }
}
