package com.yd.oss.feign.client;

import com.yd.common.result.Result;
import com.yd.oss.feign.fallback.ApiMaterialFeignFallbackFactory;
import com.yd.oss.feign.request.ApiMaterialListRequest;
import com.yd.oss.feign.response.ApiMaterialListResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 材料基础信息Feign客户端
 */
@FeignClient(name = "yd-oss-api",path = "/oss/api/material",fallbackFactory = ApiMaterialFeignFallbackFactory.class)
public interface ApiMaterialFeignClient {

    /**
     * 列表查询-材料基础信息
     * @param request
     * @return
     */
    @PostMapping("/list")
    Result<List<ApiMaterialListResponse>> list(@RequestBody ApiMaterialListRequest request);
}
