package com.yd.oss.service.dao;

import com.yd.oss.service.model.OssProvider;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * <p>
 * 云存储服务商配置表 Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-08-22
 */
public interface OssProviderMapper extends BaseMapper<OssProvider> {

    // 根据名称查询OSS提供商
    @Select("SELECT * FROM oss_provider WHERE name = #{name}")
    OssProvider selectByName(@Param("name") String name);

    // 查询默认的OSS提供商
    @Select("SELECT * FROM oss_provider WHERE is_default = 1")
    OssProvider selectDefaultProvider();

    // 查询所有激活的OSS提供商
    @Select("SELECT * FROM oss_provider WHERE is_active = 1")
    List<OssProvider> selectActiveProviders();
}
