package com.yd.oss.service.dao;

import com.yd.oss.service.model.OssFile;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * <p>
 * 文件元数据表 Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-08-22
 */
public interface OssFileMapper extends BaseMapper<OssFile> {

    // 根据文件key查询文件
    @Select("SELECT * FROM oss_file WHERE file_key = #{fileKey}")
    OssFile selectByFileKey(@Param("fileKey") String fileKey);

    // 根据上传用户查询文件
    @Select("SELECT * FROM oss_file WHERE upload_user = #{uploadUser}")
    List<OssFile> selectByUploadUser(@Param("uploadUser") String uploadUser);

    // 查询所有未删除的文件
    @Select("SELECT * FROM oss_file WHERE is_deleted = 0")
    List<OssFile> selectActiveFiles();

    // 根据提供商ID查询文件
    @Select("SELECT * FROM oss_file WHERE provider_id = #{providerId}")
    List<OssFile> selectByProviderId(@Param("providerId") Long providerId);

    // 标记文件为已删除
    @Update("UPDATE oss_file SET is_deleted = true, deleted_time = NOW() WHERE file_key = #{fileKey}")
    int markAsDeleted(@Param("fileKey") String fileKey);
}
