package com.yd.oss.service.service;

import com.yd.oss.service.dto.OssFileDto;
import com.yd.oss.service.model.OssFile;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.oss.service.model.OssOperationLog;

import java.util.List;

/**
 * <p>
 * 文件元数据表 服务类
 * </p>
 *
 * @author zxm
 * @since 2025-08-22
 */
public interface IOssFileService extends IService<OssFile> {

    boolean saveFileMetadata(OssFile ossFile);

    OssFile getFileByKey(String fileKey);

    boolean markFileAsDeleted(String fileKey);

    boolean saveOperationLog(OssOperationLog log);

    List<OssFile> getUserFiles(String uploadUser);

    List<OssFile> getActiveFiles();

    List<OssFile> getProviderFiles(Long providerId);

    List<OssOperationLog> getOperationLogsByFileId(Long fileId);

    List<OssFile> queryList(OssFileDto dto);

    OssFile queryOne(String fileBizId);
}
