package com.yd.oss.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 产品文件关系表
 * </p>
 *
 * @author zxm
 * @since 2025-10-17
 */
@Getter
@Setter
@TableName("product_file")
public class ProductFile implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 未知ID
     */
    @TableField("biz_id")
    private String bizId;

    /**
     * 产品业务ID
     */
    @TableField("product_biz_id")
    private String productBizId;

    /**
     * 文件名称
     */
    @TableField("file_name")
    private String fileName;

    /**
     * 原文件URL
     */
    @TableField("old_file_url")
    private String oldFileUrl;

    /**
     * 新文件URL
     */
    @TableField("new_file_url")
    private String newFileUrl;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Boolean isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
