package com.yd.oss.feign.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ApiUploadResponse {

    /**
     * 文件key
     */
    private String fileKey;

    /**
     * 访问URL（不带过期时间签名URL）
     */
    private String url;

    /**
     * 访问URL（带过期时间签名URL）
     */
    private String accessUrl;

    /**
     * 文件大小
     */
    private Long fileSize;

    /**
     * 文件类型
     */
    private String fileType;

    /**
     * 原始文件名
     */
    private String originalName;

    /**
     * 上传时间
     */
    private Date uploadTime;

    /**
     * 文件业务ID唯一标识
     */
    private String fileBizId;
}
