package com.yd.oss.feign.dto;

import lombok.Data;

@Data
public class ExportResult {
    /**
     * 导出是否成功
     */
    private Boolean success;
    
    /**
     * 错误信息
     */
    private String errorMsg;
    
    /**
     * 文件大小（字节）
     */
    private Long fileSize;
    
    /**
     * OSS文件URL（如果上传到OSS）
     */
    private String ossUrl;
    
    /**
     * 本地文件路径（如果不上传OSS）
     */
    private String localFilePath;
    
    public static ExportResult success(String ossUrl, Long fileSize) {
        ExportResult result = new ExportResult();
        result.setSuccess(true);
        result.setOssUrl(ossUrl);
        result.setFileSize(fileSize);
        return result;
    }
    
    public static ExportResult error(String errorMsg) {
        ExportResult result = new ExportResult();
        result.setSuccess(false);
        result.setErrorMsg(errorMsg);
        return result;
    }
}