package com.yd.oss.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.oss.feign.request.ApiRelObjectMaterialPageRequest;
import com.yd.oss.feign.response.ApiRelObjectMaterialPageResponse;
import com.yd.oss.service.model.RelObjectMaterial;
import com.yd.oss.service.dao.RelObjectMaterialMapper;
import com.yd.oss.service.service.IRelObjectMaterialService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 对象材料关系表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-12-17
 */
@Service
public class RelObjectMaterialServiceImpl extends ServiceImpl<RelObjectMaterialMapper, RelObjectMaterial> implements IRelObjectMaterialService {

    @Override
    public IPage<ApiRelObjectMaterialPageResponse> page(Page<ApiRelObjectMaterialPageResponse> page,
                                                        ApiRelObjectMaterialPageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public RelObjectMaterial queryOne(String relObjectMaterialBizId) {
        return this.getOne(new LambdaQueryWrapper<RelObjectMaterial>()
                .eq(RelObjectMaterial::getRelObjectMaterialBizId,relObjectMaterialBizId));
    }

    @Override
    public Boolean delByObjectBizId(String objectBizId) {
        return this.remove(new LambdaQueryWrapper<RelObjectMaterial>().eq(RelObjectMaterial::getObjectBizId,objectBizId));
    }

    @Override
    public List<RelObjectMaterial> queryList(String objectBizId) {
        return this.baseMapper.selectList(new LambdaQueryWrapper<RelObjectMaterial>().eq(RelObjectMaterial::getObjectBizId,objectBizId));
    }
}
