package com.yd.oss.feign.fallback;

import com.yd.common.result.Result;
import com.yd.oss.feign.client.ApiOssFeignClient;
import com.yd.oss.feign.request.ApiUploadFileRequest;
import com.yd.oss.feign.response.ApiBatchUploadResponse;
import com.yd.oss.feign.response.ApiFileMetadataResponse;
import com.yd.oss.feign.response.ApiUploadResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * OSS服务信息Feign降级处理
 */
@Slf4j
@Component
public class ApiOssFeignFallbackFactory implements FallbackFactory<ApiOssFeignClient> {
    @Override
    public ApiOssFeignClient create(Throwable cause) {
        return new ApiOssFeignClient() {
            @Override
            public Result<ApiUploadResponse> uploadFile(MultipartFile file) {
                return null;
            }

            @Override
            public Result<ApiUploadResponse> uploadFileBody(MultipartFile file, ApiUploadFileRequest request) {
                return null;
            }

            @Override
            public Result downloadFile(String fileKey) {
                return null;
            }

            @Override
            public Result<Boolean> deleteFile(String fileKey) {
                return null;
            }

            @Override
            public Result<String> getFileUrl(String fileKey, Long expirySeconds) {
                return null;
            }

            @Override
            public Result<Boolean> switchProvider(String providerName) {
                return null;
            }

            @Override
            public Result<Boolean> doesFileExist(String fileKey) {
                return null;
            }

            @Override
            public Result<ApiFileMetadataResponse> getFileMetadata(String fileKey) {
                return null;
            }

            @Override
            public Result<ApiBatchUploadResponse> batchUploadFiles(List<MultipartFile> files, ApiUploadFileRequest request) {
                return null;
            }
        };
    }
}
