package com.yd.oss.feign.fallback;

import com.yd.common.result.Result;
import com.yd.oss.feign.client.ApiPdfFeignClient;
import com.yd.oss.feign.request.ApiGeneratePdfRequest;
import com.yd.oss.feign.response.ApiGeneratePdfResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * PDF信息Feign降级处理
 */
@Slf4j
@Component
public class ApiPdfFeignFallbackFactory implements FallbackFactory<ApiPdfFeignClient> {
    @Override
    public ApiPdfFeignClient create(Throwable cause) {
        return new ApiPdfFeignClient() {
            @Override
            public Result<ApiGeneratePdfResponse> generatePDF(ApiGeneratePdfRequest request) {
                return null;
            }
        };
    }
}
