package com.yd.oss.api.controller;

import com.yd.common.result.Result;
import com.yd.oss.api.service.ApiExcelService;
import com.yd.oss.feign.client.ApiExcelFeignClient;
import com.yd.oss.feign.dto.ExportResult;
import com.yd.oss.feign.request.ApiExportRequest;
import com.yd.oss.feign.request.ApiOssExportAppointmentExcelRequest;
import com.yd.oss.feign.response.ApiOssExcelParseResponse;
import com.yd.oss.feign.response.ApiOssExportAppointmentExcelResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/**
 * Excel接口信息
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/excel")
@Validated
public class ApiExcelController implements ApiExcelFeignClient {

    @Autowired
    private ApiExcelService apiExcelService;

    /**
     * 导出excel-预约信息
     * @param request
     * @return
     */
    @Override
    public Result<ApiOssExportAppointmentExcelResponse> exportAppointment(ApiOssExportAppointmentExcelRequest request) {
        return apiExcelService.exportAppointment(request);
    }

    /**
     * 通用-Excel解析（支持多sheet页解析）
     * @param file
     * @param sheetClassNames
     * @return
     */
    @Override
    public Result<ApiOssExcelParseResponse> parse(MultipartFile file, String[] sheetClassNames) {
        return apiExcelService.parse(file,sheetClassNames);
    }

    /**
     * 导出excel（通用）
     * @return
     */
    @Override
    public Result<ExportResult> export(ApiExportRequest request) {
        return apiExcelService.export(request.getDataList(),request.getExportParam(),request.getEntityClass());
    }

}
