package com.yd.oss.feign.client;

import com.yd.common.result.Result;
import com.yd.oss.feign.dto.ExportResult;
import com.yd.oss.feign.fallback.ApiExcelFeignFallbackFactory;
import com.yd.oss.feign.request.ApiExportRequest;
import com.yd.oss.feign.request.ApiOssExportAppointmentExcelRequest;
import com.yd.oss.feign.response.ApiOssExcelParseResponse;
import com.yd.oss.feign.response.ApiOssExportAppointmentExcelResponse;
import com.yd.oss.feign.result.ImportResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

/**
 * Excel信息Feign客户端
 */
@FeignClient(name = "yd-oss-api",path = "/oss/api/excel",fallbackFactory = ApiExcelFeignFallbackFactory.class)
public interface ApiExcelFeignClient {

    /**
     * 导出excel-预约信息
     * @param request
     * @return
     */
    @PostMapping("/export/appointment")
    Result<ApiOssExportAppointmentExcelResponse> exportAppointment(@Validated @RequestBody ApiOssExportAppointmentExcelRequest request);

    /**
     * 通用-Excel解析（支持多sheet页解析）
     * @param file
     * @param sheetClassNames
     * @return
     */
    @PostMapping(value = "/parse-excel", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    Result<ApiOssExcelParseResponse> parse(@RequestPart("file") MultipartFile file,
                                           @RequestPart("sheetClassNames") String[] sheetClassNames);

    /**
     * 导出excel（通用）
     * @return
     */
    @PostMapping("/export")
    Result<ExportResult> export(@Validated @RequestBody ApiExportRequest request);

    /**
     * 通用Excel导入接口
     * @param file Excel文件
     * @param headerRow 表头行号（默认第1行，从0开始）
     * @param dataStartRow 数据开始行号（默认第2行，从0开始）
     * @param requiredFields 必填字段列表（多个字段逗号分隔）
     * @return 导入的结果
     */
    @PostMapping(value = "/import", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    Result<ImportResult> importExcel(
            @RequestPart("file") MultipartFile file,
            @RequestParam(value = "headerRow", required = false) Integer headerRow,
            @RequestParam(value = "dataStartRow", required = false) Integer dataStartRow,
            @RequestParam(value = "requiredFields", required = false) String requiredFields);

    /**
     * 简化导入接口
     * @param file
     * @return
     */
    @PostMapping("/simple-import")
    Result<ImportResult> simpleImport(@RequestParam("file") MultipartFile file);
}
