package com.yd.oss.api;

import com.yd.common.constant.ServerNameConstants;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.openfeign.EnableFeignClients;

@SpringBootApplication(scanBasePackages = "com.yd")
@MapperScan("com.yd.**.dao")
@EnableFeignClients(basePackages = "com.yd")
public class OssApiApplication {

    public static void main(String[] args) {
        new SpringApplicationBuilder(OssApiApplication.class)
                .properties("spring.application.name="+ ServerNameConstants.ydOssApi)
                .build().run(args);
        System.out.println("(♥◠‿◠)ﾉﾞ  yd-oss-api启动成功   ლ(´ڡ`ლ)ﾞ ");
    }
}
