package com.yd.oss.api.service;

import com.yd.common.result.Result;
import com.yd.oss.feign.request.ApiOssExportAppointmentExcelRequest;
import com.yd.oss.feign.response.ApiOssExcelParseResponse;
import com.yd.oss.feign.response.ApiOssExportAppointmentExcelResponse;
import com.yd.oss.feign.result.ImportResult;
import org.springframework.web.multipart.MultipartFile;

public interface ApiExcelService {

    Result<ApiOssExportAppointmentExcelResponse> exportAppointment(ApiOssExportAppointmentExcelRequest request);

    Result<ApiOssExcelParseResponse> parse(MultipartFile file, String[] sheetClassNames);

    Result<ImportResult> importExcel(MultipartFile file, Integer headerRow,
                                     Integer dataStartRow, String requiredFields);

    Result<ImportResult> simpleImport(MultipartFile file);
}
