/*
 * Decompiled with CFR 0.152.
 */
package com.yd.oss.api.controller;

import com.yd.common.result.Result;
import com.yd.oss.api.service.ApiOssService;
import com.yd.oss.feign.client.ApiOssFeignClient;
import com.yd.oss.feign.response.ApiFileMetadataResponse;
import com.yd.oss.feign.response.ApiUploadResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/oss"})
@Validated
public class ApiOssController
implements ApiOssFeignClient {
    @Autowired
    private ApiOssService apiOssService;

    public Result<ApiUploadResponse> uploadFile(MultipartFile file) {
        return this.apiOssService.uploadFile(file, "", "", "");
    }

    public Result downloadFile(String fileKey) {
        this.apiOssService.downloadFile(fileKey, "", "", null);
        return Result.success();
    }

    public Result<Boolean> deleteFile(String fileKey) {
        return this.apiOssService.deleteFile(fileKey, "", "", "");
    }

    public Result<String> getFileUrl(String fileKey, Long expirySeconds) {
        return this.apiOssService.getFileUrl(fileKey, "", "", expirySeconds);
    }

    public Result<Boolean> switchProvider(String providerName) {
        return this.apiOssService.switchProvider(providerName);
    }

    public Result<Boolean> doesFileExist(String fileKey) {
        return this.apiOssService.doesFileExist(fileKey, "", "");
    }

    public Result<ApiFileMetadataResponse> getFileMetadata(String fileKey) {
        return this.apiOssService.getFileMetadata(fileKey, "", "");
    }
}

