package com.yd.oss.api.service.impl;

import com.yd.common.result.Result;
import com.yd.oss.api.service.ApiMaterialService;
import com.yd.oss.feign.request.ApiMaterialListRequest;
import com.yd.oss.feign.response.ApiMaterialListResponse;
import com.yd.oss.service.dto.MaterialDto;
import com.yd.oss.service.model.Material;
import com.yd.oss.service.service.IMaterialService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiMaterialServiceImpl implements ApiMaterialService {

    @Autowired
    private IMaterialService iMaterialService;

    /**
     * 列表查询-材料基础信息
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiMaterialListResponse>> list(ApiMaterialListRequest request) {
        List<Material> materialList = iMaterialService.queryList(MaterialDto.builder().objectType(request.getObjectType()).build());
        if (!CollectionUtils.isEmpty(materialList)) {
            List<ApiMaterialListResponse> responses = materialList.stream().map(dto -> {
                ApiMaterialListResponse response = new ApiMaterialListResponse();
                BeanUtils.copyProperties(dto,response);
                return response;
            }).collect(Collectors.toList());
            return Result.success(responses);
        }
        return Result.success();
    }


}
