package com.yd.oss.api.controller;

import com.yd.common.result.Result;
import com.yd.oss.api.service.ApiMaterialService;
import com.yd.oss.feign.client.ApiMaterialFeignClient;
import com.yd.oss.feign.request.ApiMaterialListRequest;
import com.yd.oss.feign.response.ApiMaterialListResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 材料基础信息
 *
 * @author zxm
 * @since 2025-12-17
 */
@RestController
@RequestMapping("/material")
@Validated
public class ApiMaterialController implements ApiMaterialFeignClient {

    @Autowired
    private ApiMaterialService apiMaterialService;

    /**
     * 列表查询-材料基础信息
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiMaterialListResponse>> list(ApiMaterialListRequest request) {
        return apiMaterialService.list(request);
    }
}
