package com.yd.oss.feign.result;

import java.util.ArrayList;
import java.util.List;

/**
 * 数据验证结果
 */
public class ValidationResult {
    private boolean valid;
    private List<String> errors;
    
    public ValidationResult() {
        this.errors = new ArrayList<>();
        this.valid = true;
    }
    
    // getter和setter方法
    public boolean isValid() {
        return valid;
    }
    
    public void setValid(boolean valid) {
        this.valid = valid;
    }
    
    public List<String> getErrors() {
        return errors;
    }
    
    public void setErrors(List<String> errors) {
        this.errors = errors;
    }
    
    public void addError(String error) {
        this.errors.add(error);
        this.valid = false;
    }
    
    public String getErrorMsg() {
        return String.join("; ", errors);
    }
}