package com.yd.oss.service.service;

import com.yd.oss.service.dto.FileMetadata;
import com.yd.oss.service.dto.UploadResult;
import com.yd.oss.service.model.OssProvider;

import java.io.InputStream;
import java.time.Duration;

/**
 * OSS操作通用接口
 */
public interface OssService {

    // 上传文件
    String uploadFile(InputStream inputStream, String fileName, String bucketName, String uploadUser);

    // 上传文件（使用默认存储桶）
    String uploadFile(InputStream inputStream, String fileName, String uploadUser);

    // 下载文件
    InputStream downloadFile(String fileKey, String bucketName);

    // 下载文件（使用默认存储桶）
    InputStream downloadFile(String fileKey);

    // 删除文件
    boolean deleteFile(String fileKey, String bucketName, String operator);

    // 删除文件（使用默认存储桶）
    boolean deleteFile(String fileKey, String operator);

    // 获取文件URL
    String getFileUrl(String fileKey, String bucketName, Duration expiration);

    // 获取文件URL（使用默认存储桶）
    String getFileUrl(String fileKey, Duration expiration);

    // 判断文件是否存在
    boolean doesFileExist(String fileKey, String bucketName);

    // 判断文件是否存在（使用默认存储桶）
    boolean doesFileExist(String fileKey);

    // 获取文件元数据
    FileMetadata getFileMetadata(String fileKey, String bucketName);

    // 获取文件元数据（使用默认存储桶）
    FileMetadata getFileMetadata(String fileKey);

    // 切换OSS提供商
    void switchProvider(String providerName);

    // 切换OSS提供商（通过ID）
    void switchProvider(Long providerId);

    // 获取当前使用的提供商
    OssProvider getCurrentProvider();

    // 设置默认存储桶
    void setDefaultBucket(String bucketName);

    // 获取默认存储桶
    String getDefaultBucket();

    // 获取上传结果（包含文件信息和访问URL）
    UploadResult getUploadResult(String fileKey, Duration expiration);
}

