/*
 * Decompiled with CFR 0.152.
 */
package com.yd.oss.service.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.common.exception.BusinessException;
import com.yd.oss.service.dao.OssFileMapper;
import com.yd.oss.service.dao.OssOperationLogMapper;
import com.yd.oss.service.model.OssFile;
import com.yd.oss.service.model.OssOperationLog;
import com.yd.oss.service.service.IOssFileService;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class OssFileServiceImpl
extends ServiceImpl<OssFileMapper, OssFile>
implements IOssFileService {
    private static final Logger log = LoggerFactory.getLogger(OssFileServiceImpl.class);
    @Autowired
    private OssFileMapper ossFileMapper;
    @Autowired
    private OssOperationLogMapper ossOperationLogMapper;

    @Override
    public boolean saveFileMetadata(OssFile ossFile) {
        if (ossFile.getId() == null) {
            ossFile.setUploadTime(LocalDateTime.now());
            ossFile.setIsDeleted(0);
            return this.ossFileMapper.insert(ossFile) > 0;
        }
        return this.ossFileMapper.updateById(ossFile) > 0;
    }

    @Override
    public OssFile getFileByKey(String fileKey) {
        OssFile file = this.ossFileMapper.selectByFileKey(fileKey);
        if (file == null) {
            log.error("\u672a\u627e\u5230\u6587\u4ef6: {}", (Object)fileKey);
            throw new BusinessException("\u672a\u627e\u5230\u6587\u4ef6: " + fileKey);
        }
        return file;
    }

    @Override
    public boolean markFileAsDeleted(String fileKey) {
        return this.ossFileMapper.markAsDeleted(fileKey) > 0;
    }

    @Override
    public boolean saveOperationLog(OssOperationLog log) {
        return this.ossOperationLogMapper.insert(log) > 0;
    }

    @Override
    public List<OssFile> getUserFiles(String uploadUser) {
        return this.ossFileMapper.selectByUploadUser(uploadUser);
    }

    @Override
    public List<OssFile> getActiveFiles() {
        return this.ossFileMapper.selectActiveFiles();
    }

    @Override
    public List<OssFile> getProviderFiles(Long providerId) {
        return this.ossFileMapper.selectByProviderId(providerId);
    }

    @Override
    public List<OssOperationLog> getOperationLogsByFileId(Long fileId) {
        return this.ossOperationLogMapper.selectByFileId(fileId);
    }
}

