/*
 * Decompiled with CFR 0.152.
 */
package com.yd.oss.service.service.impl;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.yd.oss.service.dto.FileMetadata;
import com.yd.oss.service.dto.UploadResult;
import com.yd.oss.service.model.OssFile;
import com.yd.oss.service.model.OssOperationLog;
import com.yd.oss.service.model.OssProvider;
import com.yd.oss.service.service.IOssFileService;
import com.yd.oss.service.service.IOssProviderService;
import com.yd.oss.service.service.OssService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
@Primary
public class AliYunOssServiceImpl
implements OssService {
    private static final Logger log = LoggerFactory.getLogger(AliYunOssServiceImpl.class);
    @Autowired
    private IOssProviderService ossProviderService;
    @Autowired
    private IOssFileService ossFileService;
    private OSS ossClient;
    private OssProvider currentProvider;
    private String defaultBucket;

    @PostConstruct
    public void init() {
        try {
            this.currentProvider = this.ossProviderService.getDefaultProvider();
            this.ossClient = this.createOssClient(this.currentProvider);
            this.defaultBucket = this.currentProvider.getBucketName();
            log.info("\u963f\u91cc\u4e91OSS\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u6210\u529f\uff0c\u4f7f\u7528\u63d0\u4f9b\u5546: {}", (Object)this.currentProvider.getName());
        }
        catch (Exception e) {
            log.error("\u963f\u91cc\u4e91OSS\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u963f\u91cc\u4e91OSS\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }

    private OSS createOssClient(OssProvider provider) {
        return new OSSClientBuilder().build(provider.getEndpoint(), provider.getAccessKey(), provider.getSecretKey());
    }

    @Override
    public String uploadFile(InputStream inputStream, String fileName, String bucketName, String uploadUser) {
        long startTime = System.currentTimeMillis();
        String operationResult = "success";
        String errorMessage = null;
        OssFile ossFile = null;
        try {
            String fileKey = this.generateFileKey(fileName);
            String actualBucket = StringUtils.isNotBlank((CharSequence)bucketName) ? bucketName : this.defaultBucket;
            Long fileSize = this.getInputStreamSize(inputStream);
            String fileType = this.getFileType(fileName);
            inputStream = this.resetInputStream(inputStream, fileSize);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(fileSize.longValue());
            metadata.setContentType(this.getContentType(fileType));
            PutObjectRequest putObjectRequest = new PutObjectRequest(actualBucket, fileKey, inputStream, metadata);
            this.ossClient.putObject(putObjectRequest);
            ossFile = new OssFile();
            ossFile.setFileKey(fileKey);
            ossFile.setOriginalName(fileName);
            ossFile.setFileSize(fileSize);
            ossFile.setFileType(fileType);
            ossFile.setProviderBizId(this.currentProvider.getProviderBizId());
            ossFile.setBucketName(actualBucket);
            ossFile.setUploadUser(uploadUser);
            this.ossFileService.saveFileMetadata(ossFile);
            OssOperationLog operationLog = new OssOperationLog();
            operationLog.setFileBizId(ossFile.getFileBizId());
            operationLog.setOperationType("upload");
            operationLog.setOperationUser(uploadUser);
            operationLog.setOperationResult(operationResult);
            operationLog.setErrorMessage(errorMessage);
            operationLog.setClientIp(this.getClientIp());
            operationLog.setCostTime(System.currentTimeMillis() - startTime);
            this.ossFileService.saveOperationLog(operationLog);
            log.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f: {} -> {}/{}", new Object[]{fileName, actualBucket, fileKey});
            String string = fileKey;
            return string;
        }
        catch (Exception e) {
            operationResult = "failure";
            errorMessage = e.getMessage();
            log.error("\u963f\u91cc\u4e91OSS\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25: {}", (Object)fileName, (Object)e);
            throw new RuntimeException("\u963f\u91cc\u4e91OSS\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25: " + fileName, e);
        }
        finally {
            this.closeQuietly(inputStream);
            if ("failure".equals(operationResult)) {
                OssOperationLog operationLog = new OssOperationLog();
                if (ossFile != null) {
                    operationLog.setFileBizId(ossFile.getFileBizId());
                } else {
                    operationLog.setFileBizId("-1");
                }
                operationLog.setOperationType("upload");
                operationLog.setOperationUser(uploadUser);
                operationLog.setOperationResult(operationResult);
                operationLog.setErrorMessage(errorMessage);
                operationLog.setClientIp(this.getClientIp());
                operationLog.setCostTime(System.currentTimeMillis() - startTime);
                this.ossFileService.saveOperationLog(operationLog);
            }
        }
    }

    @Override
    public String uploadFile(InputStream inputStream, String fileName, String uploadUser) {
        return this.uploadFile(inputStream, fileName, this.defaultBucket, uploadUser);
    }

    @Override
    public InputStream downloadFile(String fileKey, String bucketName) {
        long startTime = System.currentTimeMillis();
        String operationResult = "success";
        String errorMessage = null;
        OssFile ossFile = null;
        try {
            String actualBucket = StringUtils.isNotBlank((CharSequence)bucketName) ? bucketName : this.defaultBucket;
            ossFile = this.ossFileService.getFileByKey(fileKey);
            OSSObject ossObject = this.ossClient.getObject(actualBucket, fileKey);
            InputStream inputStream = ossObject.getObjectContent();
            OssOperationLog operationLog = new OssOperationLog();
            operationLog.setFileBizId(ossFile.getFileBizId());
            operationLog.setOperationType("download");
            operationLog.setOperationUser("system");
            operationLog.setOperationResult(operationResult);
            operationLog.setErrorMessage(errorMessage);
            operationLog.setClientIp(this.getClientIp());
            operationLog.setCostTime(System.currentTimeMillis() - startTime);
            this.ossFileService.saveOperationLog(operationLog);
            log.info("\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f: {}/{}", (Object)actualBucket, (Object)fileKey);
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        catch (Exception e) {
            operationResult = "failure";
            errorMessage = e.getMessage();
            log.error("\u963f\u91cc\u4e91OSS\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25: {}", (Object)fileKey, (Object)e);
            throw new RuntimeException("\u963f\u91cc\u4e91OSS\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25: " + fileKey, e);
        }
        finally {
            if ("failure".equals(operationResult)) {
                OssOperationLog operationLog = new OssOperationLog();
                if (ossFile != null) {
                    operationLog.setFileBizId(ossFile.getFileBizId());
                } else {
                    operationLog.setFileBizId("-1");
                }
                operationLog.setOperationType("download");
                operationLog.setOperationUser("system");
                operationLog.setOperationResult(operationResult);
                operationLog.setErrorMessage(errorMessage);
                operationLog.setClientIp(this.getClientIp());
                operationLog.setCostTime(System.currentTimeMillis() - startTime);
                this.ossFileService.saveOperationLog(operationLog);
            }
        }
    }

    @Override
    public InputStream downloadFile(String fileKey) {
        return this.downloadFile(fileKey, this.defaultBucket);
    }

    @Override
    public boolean deleteFile(String fileKey, String bucketName, String operator) {
        long startTime = System.currentTimeMillis();
        String operationResult = "success";
        String errorMessage = null;
        OssFile ossFile = null;
        try {
            String actualBucket = StringUtils.isNotBlank((CharSequence)bucketName) ? bucketName : this.defaultBucket;
            ossFile = this.ossFileService.getFileByKey(fileKey);
            this.ossClient.deleteObject(actualBucket, fileKey);
            this.ossFileService.markFileAsDeleted(fileKey);
            OssOperationLog operationLog = new OssOperationLog();
            operationLog.setFileBizId(ossFile.getFileBizId());
            operationLog.setOperationType("delete");
            operationLog.setOperationUser(operator);
            operationLog.setOperationResult(operationResult);
            operationLog.setErrorMessage(errorMessage);
            operationLog.setClientIp(this.getClientIp());
            operationLog.setCostTime(System.currentTimeMillis() - startTime);
            this.ossFileService.saveOperationLog(operationLog);
            log.info("\u6587\u4ef6\u5220\u9664\u6210\u529f: {}/{}", (Object)actualBucket, (Object)fileKey);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            operationResult = "failure";
            errorMessage = e.getMessage();
            log.error("\u963f\u91cc\u4e91OSS\u5220\u9664\u6587\u4ef6\u5931\u8d25: {}", (Object)fileKey, (Object)e);
            throw new RuntimeException("\u963f\u91cc\u4e91OSS\u5220\u9664\u6587\u4ef6\u5931\u8d25: " + fileKey, e);
        }
        finally {
            if ("failure".equals(operationResult)) {
                OssOperationLog operationLog = new OssOperationLog();
                if (ossFile != null) {
                    operationLog.setFileBizId(ossFile.getFileBizId());
                } else {
                    operationLog.setFileBizId("-1");
                }
                operationLog.setOperationType("delete");
                operationLog.setOperationUser(operator);
                operationLog.setOperationResult(operationResult);
                operationLog.setErrorMessage(errorMessage);
                operationLog.setClientIp(this.getClientIp());
                operationLog.setCostTime(System.currentTimeMillis() - startTime);
                this.ossFileService.saveOperationLog(operationLog);
            }
        }
    }

    @Override
    public boolean deleteFile(String fileKey, String operator) {
        return this.deleteFile(fileKey, this.defaultBucket, operator);
    }

    @Override
    public String getFileUrl(String fileKey, String bucketName, Duration expiration) {
        try {
            String actualBucket = StringUtils.isNotBlank((CharSequence)bucketName) ? bucketName : this.defaultBucket;
            Date expirationDate = new Date(System.currentTimeMillis() + expiration.toMillis());
            URL url = this.ossClient.generatePresignedUrl(actualBucket, fileKey, expirationDate);
            return url.toString();
        }
        catch (Exception e) {
            log.error("\u963f\u91cc\u4e91OSS\u83b7\u53d6\u6587\u4ef6URL\u5931\u8d25: {}", (Object)fileKey, (Object)e);
            throw new RuntimeException("\u963f\u91cc\u4e91OSS\u83b7\u53d6\u6587\u4ef6URL\u5931\u8d25: " + fileKey, e);
        }
    }

    @Override
    public String getFileUrl(String fileKey, Duration expiration) {
        return this.getFileUrl(fileKey, this.defaultBucket, expiration);
    }

    @Override
    public boolean doesFileExist(String fileKey, String bucketName) {
        try {
            String actualBucket = StringUtils.isNotBlank((CharSequence)bucketName) ? bucketName : this.defaultBucket;
            return this.ossClient.doesObjectExist(actualBucket, fileKey);
        }
        catch (Exception e) {
            log.error("\u963f\u91cc\u4e91OSS\u68c0\u67e5\u6587\u4ef6\u5b58\u5728\u5931\u8d25: {}", (Object)fileKey, (Object)e);
            throw new RuntimeException("\u963f\u91cc\u4e91OSS\u68c0\u67e5\u6587\u4ef6\u5b58\u5728\u5931\u8d25: " + fileKey, e);
        }
    }

    @Override
    public boolean doesFileExist(String fileKey) {
        return this.doesFileExist(fileKey, this.defaultBucket);
    }

    @Override
    public FileMetadata getFileMetadata(String fileKey, String bucketName) {
        try {
            String actualBucket = StringUtils.isNotBlank((CharSequence)bucketName) ? bucketName : this.defaultBucket;
            ObjectMetadata objectMetadata = this.ossClient.getObjectMetadata(actualBucket, fileKey);
            FileMetadata metadata = new FileMetadata();
            metadata.setFileKey(fileKey);
            metadata.setFileSize(objectMetadata.getContentLength());
            metadata.setContentType(objectMetadata.getContentType());
            metadata.setEtag(objectMetadata.getETag());
            return metadata;
        }
        catch (Exception e) {
            log.error("\u963f\u91cc\u4e91OSS\u83b7\u53d6\u6587\u4ef6\u5143\u6570\u636e\u5931\u8d25: {}", (Object)fileKey, (Object)e);
            throw new RuntimeException("\u963f\u91cc\u4e91OSS\u83b7\u53d6\u6587\u4ef6\u5143\u6570\u636e\u5931\u8d25: " + fileKey, e);
        }
    }

    @Override
    public FileMetadata getFileMetadata(String fileKey) {
        return this.getFileMetadata(fileKey, this.defaultBucket);
    }

    @Override
    public void switchProvider(String providerName) {
        try {
            OssProvider provider = this.ossProviderService.getProviderByName(providerName);
            this.switchToProvider(provider);
            log.info("\u5df2\u5207\u6362\u5230OSS\u63d0\u4f9b\u5546: {}", (Object)providerName);
        }
        catch (Exception e) {
            log.error("\u5207\u6362OSS\u63d0\u4f9b\u5546\u5931\u8d25: {}", (Object)providerName, (Object)e);
            throw new RuntimeException("\u5207\u6362OSS\u63d0\u4f9b\u5546\u5931\u8d25: " + providerName, e);
        }
    }

    @Override
    public void switchProvider(Long providerId) {
        try {
            OssProvider provider = this.ossProviderService.getProviderById(providerId);
            this.switchToProvider(provider);
            log.info("\u5df2\u5207\u6362\u5230OSS\u63d0\u4f9b\u5546ID: {}", (Object)providerId);
        }
        catch (Exception e) {
            log.error("\u5207\u6362OSS\u63d0\u4f9b\u5546\u5931\u8d25: {}", (Object)providerId, (Object)e);
            throw new RuntimeException("\u5207\u6362OSS\u63d0\u4f9b\u5546\u5931\u8d25: " + providerId, e);
        }
    }

    private void switchToProvider(OssProvider provider) {
        if (this.ossClient != null) {
            this.ossClient.shutdown();
        }
        this.currentProvider = provider;
        this.ossClient = this.createOssClient(provider);
        this.defaultBucket = provider.getBucketName();
    }

    @Override
    public OssProvider getCurrentProvider() {
        return this.currentProvider;
    }

    @Override
    public void setDefaultBucket(String bucketName) {
        this.defaultBucket = bucketName;
        log.info("\u5df2\u8bbe\u7f6e\u9ed8\u8ba4\u5b58\u50a8\u6876: {}", (Object)bucketName);
    }

    @Override
    public String getDefaultBucket() {
        return this.defaultBucket;
    }

    @Override
    public UploadResult getUploadResult(String fileKey, Duration expiration) {
        try {
            OssFile file = this.ossFileService.getFileByKey(fileKey);
            String accessUrl = this.getFileUrl(fileKey, expiration);
            UploadResult result = new UploadResult();
            result.setFileKey(fileKey);
            result.setAccessUrl(accessUrl);
            result.setFileSize(file.getFileSize());
            result.setFileType(file.getFileType());
            result.setOriginalName(file.getOriginalName());
            result.setUploadTime(file.getUploadTime());
            return result;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e0a\u4f20\u7ed3\u679c\u5931\u8d25: {}", (Object)fileKey, (Object)e);
            throw new RuntimeException("\u83b7\u53d6\u4e0a\u4f20\u7ed3\u679c\u5931\u8d25: " + fileKey, e);
        }
    }

    private String generateFileKey(String originalFileName) {
        String fileExtension = originalFileName.contains(".") ? originalFileName.substring(originalFileName.lastIndexOf(".")) : "";
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy/MM/dd/")) + UUID.randomUUID().toString().replace("-", "") + fileExtension;
    }

    private Long getInputStreamSize(InputStream inputStream) throws IOException {
        int len;
        if (inputStream instanceof ByteArrayInputStream) {
            return inputStream.available();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        long size = 0L;
        while ((len = inputStream.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
            size += (long)len;
        }
        return size;
    }

    private InputStream resetInputStream(InputStream originalStream, long size) throws IOException {
        if (originalStream instanceof ByteArrayInputStream) {
            ((ByteArrayInputStream)originalStream).reset();
            return originalStream;
        }
        byte[] data = new byte[(int)size];
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            ByteArrayInputStream byteArrayInputStream = bais;
            return byteArrayInputStream;
        }
    }

    private String getFileType(String fileName) {
        return fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".") + 1) : "";
    }

    private String getContentType(String fileType) {
        switch (fileType.toLowerCase()) {
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "png": {
                return "image/png";
            }
            case "gif": {
                return "image/gif";
            }
            case "pdf": {
                return "application/pdf";
            }
            case "txt": {
                return "text/plain";
            }
            case "html": {
                return "text/html";
            }
            case "css": {
                return "text/css";
            }
            case "js": {
                return "application/javascript";
            }
        }
        return "application/octet-stream";
    }

    private String getClientIp() {
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String ip = request.getHeader("X-Forwarded-For");
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
            }
            return ip;
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private OssFile createDummyOssFile() {
        OssFile file = new OssFile();
        file.setId(-1L);
        return file;
    }
}

