package com.yd.oss.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 云存储服务商配置表
 * </p>
 *
 * @author zxm
 * @since 2025-08-22
 */
@Getter
@Setter
@TableName("oss_provider")
public class OssProvider implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 业务ID唯一标识
     */
    @TableField("provider_biz_id")
    private String providerBizId;

    /**
     * 服务商编码（业务编码）
     */
    @TableField("code")
    private String code;

    /**
     * 服务商名称(阿里云、腾讯云等)
     */
    @TableField("name")
    private String name;

    /**
     * 服务端点
     */
    @TableField("endpoint")
    private String endpoint;

    /**
     * 访问密钥ID
     */
    @TableField("access_key")
    private String accessKey;

    /**
     * 访问密钥
     */
    @TableField("secret_key")
    private String secretKey;

    /**
     * 存储桶名称
     */
    @TableField("bucket_name")
    private String bucketName;

    /**
     * 区域
     */
    @TableField("region")
    private String region;

    /**
     * 是否默认提供商 0-否 1-是
     */
    @TableField("is_default")
    private Integer isDefault;

    /**
     * 是否激活 0-否 1-是
     */
    @TableField("is_active")
    private Integer isActive;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
