package com.yd.oss.feign.client;

import com.yd.common.result.Result;
import com.yd.oss.feign.fallback.ApiOssFileFeignFallbackFactory;
import com.yd.oss.feign.request.ApiOssFileListRequest;
import com.yd.oss.feign.response.ApiOssFileListResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 文件元数据信息Feign客户端
 */
@FeignClient(name = "yd-oss-api",path = "/oss/api/ossFile",fallbackFactory = ApiOssFileFeignFallbackFactory.class)
public interface ApiOssFileFeignClient {

    /**
     * 列表查询-文件元数据信息
     * @param request
     * @return
     */
    @PostMapping("/list")
    Result<List<ApiOssFileListResponse>> list(@Validated @RequestBody ApiOssFileListRequest request);

    /**
     * 删除-文件元数据信息
     * @param fileBizId
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "文件元数据表唯一业务ID不能为空") @RequestParam(value = "fileBizId") String fileBizId);

}
