package com.yd.oss.feign.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
public class ApiRelObjectMaterialListAddRequest {

    /**
     * 对象类型
     */
    private String objectType;

    /**
     * 对象所属表名（预约表、新单跟进表等）
     */
    private String objectTableName;

    /**
     * 对象名
     */
    private String objectName;

    /**
     * 对象业务ID
     */
    @NotBlank(message = "对象业务ID不能为空")
    private String objectBizId;

    /**
     * 材料信息表唯一业务ID列表
     */
    private List<String> materialBizIdList;
}
