import request from '@/utils/request'

// 查询产品上架列表
export function getProductList(data) {
  return request({
    url: '/product/api/product/page',
    method: 'post',
    data: data
  })
}
// 查询产品上架列表
export function getCategoryTreeList(data) {
  return request({
    url: '/base/api/category/page',
    method: 'post',
    data: data
  })
}
// 新增产品
export function addProduct(data) {
  return request({
    url: '/product/api/productLaunch/add/category',
    method: 'post',
    data: data
  })
}
// 获取产品详情
export function getProductDetail(productLaunchBizId) {
  return request({
    url: `/product/api/productLaunch/detail?productLaunchBizId=${productLaunchBizId}`,
    method: 'get'
  })
}
// 查询产品参数信息
export function productParams(data) {
  return request({
    url: '/base/api/relObjectField/query',
    method: 'post',
    data: data
  })
}
// 查询产品参数右侧下拉框数据
export function ParamRightOptions(data) {
  return request({
    url: '/base/api/relFieldValue/field/list',
    method: 'post',
    data: data
  })
}
// 查询产品规格信息列表
export function productSpecies(data) {
  return request({
    url: '/base/api/relObjectSpecies/query',
    method: 'post',
    data: data
  })
}
// 查询选中的分类列表
export function querySelectCategory(data) {
  return request({
    url: '/base/api/relObjectCategory/query/selected',
    method: 'post',
    data: data
  })
}
// 保存上架产品
export function saveProductLaunch(data) {
  return request({
    url: '/product/api/productLaunch/save',
    method: 'post',
    data: data
  })
}
// 发佣管理更新规格信息
export function exportSpecies(data) {
  return request({
    url: '/product/api/announcementSpecies/import/species',
    method: 'post',
    data: data
  })
}
// 发佣管理查询公告佣列表
export function sendSpecies(data) {
  return request({
    url: '/product/api/announcementSpecies/page',
    method: 'post',
    data: data
  })
}
// 发佣管理查询公告佣金明细列表
export function sendCommissionRatio(data) {
  return request({
    url: '/product/api/announcementCommissionRatio/page',
    method: 'post',
    data: data
  })
}
// 发佣管理批量保存公告佣金设置
export function saveBatchSendCommission(data) {
  return request({
    url: '/product/api/announcementCommissionRatio/batch/save',
    method: 'post',
    data: data
  })
}
// 发佣管理单个删除公告佣金设置
export function deleteCommission(announcementCommissionRatioBizId) {
  return request({
    url: `/product/api/announcementCommissionRatio/del?announcementCommissionRatioBizId=${announcementCommissionRatioBizId}`,
    method: 'delete'
  })
}
// 获得来佣规格数据
export function comeCommissionList(data) {
  return request({
    url: '/product/api/expectedSpecies/page',
    method: 'post',
    data: data
  })
}
// 更新产品规格数据
export function comeExpectedSpecies(data) {
  return request({
    url: '/product/api/expectedSpecies/import/species',
    method: 'post',
    data: data
  })
}
// 批量保存来佣佣金设置
export function comeBatchSave(data) {
  return request({
    url: '/product/api/expectedCommissionRatio/batch/save',
    method: 'post',
    data: data
  })
}
// 批量保存来佣佣金设置
export function comeCommissionRatio(data) {
  return request({
    url: '/product/api/expectedCommissionRatio/page',
    method: 'post',
    data: data
  })
}
// 来佣管理单个删除佣金设置
export function deleteComeCommission(expectedCommissionRatioBizId) {
  return request({
    url: `/product/api/expectedCommissionRatio/del?expectedCommissionRatioBizId=${expectedCommissionRatioBizId}`,
    method: 'delete'
  })
}
// 商品列表
export function goodsList(data) {
  return request({
    url: '/product/api/productLaunch/page',
    method: 'post',
    data: data
  })
}
// 审核商品状态
export function productApproval(data) {
  return request({
    url: '/product/api/productLaunch/approval',
    method: 'put',
    data: data
  })
}
// 修改商品上架下架状态
export function changeProductStatus(data) {
  return request({
    url: '/product/api/productLaunch/edit/status',
    method: 'put',
    data: data
  })
}
// 修改来佣佣金设置状态
export function changeComeStatus(data) {
  return request({
    url: `/product/api/expectedCommissionRatio/edit/status?expectedCommissionRatioBizId=${data.expectedCommissionRatioBizId}&status=${data.status}`,
    method: 'put'
  })
}
// 修改发佣佣金设置状态
export function changeSendStatus(data) {
  return request({
    url: `/product/api/announcementCommissionRatio/edit/status?announcementCommissionRatioBizId=${data.announcementCommissionRatioBizId}&status=${data.status}`,
    method: 'put'
  })
}
