package com.yd.insurance.base.feign.response;

import com.yd.insurance.base.feign.dto.CdDeptDto;
import com.yd.insurance.base.feign.dto.InsuranceAdditionalProductDto;
import com.yd.insurance.base.feign.dto.PlanDto;
import com.yd.insurance.base.feign.dto.SsDeptDto;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ApiInsuranceProductDetailResponse {

    /**
     * 保险产品主键id
     */
    private Long id;

    /**
     * 保险产品唯一业务ID
     */
    private String productBizId;

    /**
     * 保险产品名称
     */
    private String productName;

    /**
     * 保险产品类型
     */
    private String productType;

    /**
     * 支持货币
     */
    private String currency;

    /**
     * 供款年期
     */
    private String paymentTerm;

    /**
     * 受保年龄范围
     */
    private String insuredAgeRange;

    /**
     * 是否区分吸烟：0=不区分，1=区分
     */
    private Integer smokingAllowed;

    /**
     * 保障内容
     */
    private String coverageContent;

    /**
     * 基础费率
     */
    private BigDecimal premiumRate;

    /**
     * 保险产品状态：0=下架，1=在售
     */
    private Integer productStatus;

    /**
     * 作用域(1:系统级（全局） 2:租户级 3:项目级)
     */
    private Integer scope;

    /**
     * 所属租户ID（业务id）
     */
    private String tenantBizId;

    /**
     * 所属租户名称
     */
    private String tenantName;

    /**
     * 所属项目ID（业务id）
     */
    private String projectBizId;

    /**
     * 所属项目名称
     */
    private String projectName;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 绑定供款年期列表
     */
    private List<String> paymentTermList;

    /**
     * 绑定产品所属保险公司对象集合
     */
    private List<SsDeptDto> ssDeptDtoList;

    /**
     * 绑定保险产品出单公司对象集合
     */
    private List<CdDeptDto> cdDeptDtoList;

    /**
     * 绑定保险产品计划对象集合
     */
    private List<PlanDto> planDtoList;

    /**
     * 绑定保险附加产品对象集合
     */
    private List<InsuranceAdditionalProductDto> insuranceAdditionalProductDtoList;

    /**
     * 产品图片
     */
    private String picture;
}
