package com.yd.insurance.base.feign.fallback.insurancecompany;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.client.insurancecompany.ApiInsuranceCompanyFeignClient;
import com.yd.insurance.base.feign.request.insurancecompany.ApiInsuranceCompanyAddRequest;
import com.yd.insurance.base.feign.request.insurancecompany.ApiInsuranceCompanyEditRequest;
import com.yd.insurance.base.feign.request.insurancecompany.ApiInsuranceCompanyPageRequest;
import com.yd.insurance.base.feign.response.insurancecompany.ApiInsuranceCompanyDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 保险公司信息Feign降级处理
 */
@Slf4j
@Component
public class ApiInsuranceCompanyFeignFallbackFactory implements FallbackFactory<ApiInsuranceCompanyFeignClient> {
    @Override
    public ApiInsuranceCompanyFeignClient create(Throwable cause) {
        return new ApiInsuranceCompanyFeignClient() {
            @Override
            public Result page(ApiInsuranceCompanyPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiInsuranceCompanyDetailResponse> detail(String insuranceCompanyBizId) {
                return null;
            }

            @Override
            public Result add(ApiInsuranceCompanyAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiInsuranceCompanyEditRequest request) {
                return null;
            }

            @Override
            public Result del(String insuranceCompanyBizId) {
                return null;
            }

            @Override
            public Result editStatus(String insuranceCompanyBizId,String cooperationStatus) {
                return null;
            }
        };
    }
}
