package com.yd.insurance.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.insurance.base.feign.request.insurancecompany.ApiInsuranceCompanyPageRequest;
import com.yd.insurance.base.feign.response.insurancecompany.ApiInsuranceCompanyPageResponse;
import com.yd.insurance.base.service.dto.InsuranceCompanyDto;
import com.yd.insurance.base.service.model.InsuranceAdditionalProduct;
import com.yd.insurance.base.service.model.InsuranceCompany;
import com.yd.insurance.base.service.dao.InsuranceCompanyMapper;
import com.yd.insurance.base.service.service.IInsuranceCompanyService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 保险公司表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-12-22
 */
@Service
public class InsuranceCompanyServiceImpl extends ServiceImpl<InsuranceCompanyMapper, InsuranceCompany> implements IInsuranceCompanyService {

    @Override
    public IPage<ApiInsuranceCompanyPageResponse> page(Page<ApiInsuranceCompanyPageResponse> page,
                                                       ApiInsuranceCompanyPageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public InsuranceCompany queryOne(String insuranceCompanyBizId) {
        return this.getOne(new LambdaQueryWrapper<InsuranceCompany>()
                .eq(InsuranceCompany::getInsuranceCompanyBizId,insuranceCompanyBizId));
    }

    @Override
    public List<InsuranceCompany> queryList(InsuranceCompanyDto dto) {
        List<InsuranceCompany> list = baseMapper.selectList(new LambdaQueryWrapper<InsuranceCompany>()
                .eq(StringUtils.isNotBlank(dto.getInsuranceCompanyBizId()) && !dto.getIsExcludeMy(),InsuranceCompany::getInsuranceCompanyBizId,dto.getInsuranceCompanyBizId())
                .eq(StringUtils.isNotBlank(dto.getFullName()),InsuranceCompany::getFullName,dto.getFullName())
                .ne(dto.getIsExcludeMy(),InsuranceCompany::getInsuranceCompanyBizId,dto.getInsuranceCompanyBizId())
        );
        return list;
    }
}
