package com.yd.insurance.base.feign.response.usersignexpand;

import lombok.Data;

import java.time.LocalDateTime;

@Data
public class ApiUserSignExpandPageResponse {

    /**
     * 签单用户扩展表主键ID
     */
    private Long id;

    /**
     * 签单用户扩展唯一业务ID
     */
    private String userSignBizId;

    /**
     * 系统用户唯一标识(业务ID)
     */
    private String userBizId;

    /**
     * 客户端用户表唯一业务ID
     */
    private String clientUserBizId;

    /**
     * 签单用户真实姓名
     */
    private String realName;

    /**
     * 内部编号
     */
    private String internalNumber;

    /**
     * 执业编码
     */
    private String practiceCode;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 证件类型
     */
    private String cardType;

    /**
     * 证件号码
     */
    private String cardNo;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 性别(0:未知 1:男 2:女)
     */
    private Integer gender;

    /**
     * 所属公司ID（部门唯一标识(业务ID)）
     */
    private String deptBizId;

    /**
     * 所属公司名称（部门名称）
     */
    private String deptName;

    /**
     * 推荐等级：
     *
     * 一般
     * 推荐
     * 非常推荐
     * 不推荐
     */
    private String recommendedLevel;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
