package com.yd.insurance.base.feign.request;

import com.yd.common.dto.PageDto;
import lombok.Data;

@Data
public class ApiInsuranceProductPageRequest extends PageDto {

    /**
     * 当前登录用户所属的租户id（当前页面右上角显示的租户）
     */
    private String loginTenantBizId;

    /**
     * 保险产品名称
     */
    private String productName;

    /**
     * 保险产品类型（险种）
     */
    private String productType;

    /**
     * 保险公司（产品所属保险公司，部门业务id）
     */
    private String deptBizId;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;
}
