package com.yd.insurance.base.feign.client.usersaleexpand;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.fallback.usersaleexpand.ApiUserSaleExpandFeignFallbackFactory;
import com.yd.insurance.base.feign.request.usersaleexpand.ApiUserSaleExpandAddRequest;
import com.yd.insurance.base.feign.request.usersaleexpand.ApiUserSaleExpandEditRequest;
import com.yd.insurance.base.feign.request.usersaleexpand.ApiUserSaleExpandPageRequest;
import com.yd.insurance.base.feign.response.usersaleexpand.ApiUserSaleExpandDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 系统用户-销售用户扩展信息Feign客户端
 */
@FeignClient(name = "yd-user-api", path = "/user/api/userSaleExpand",fallbackFactory = ApiUserSaleExpandFeignFallbackFactory.class)
public interface ApiUserSaleExpandFeignClient {

    /**
     * 销售员（转介人）分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiUserSaleExpandPageRequest request);

    /**
     * 获取销售员（转介人）详情
     * @param userSaleBizId 销售员（转介人）唯一标识(业务ID)
     * @return
     */
    @GetMapping("/detail")
    Result<ApiUserSaleExpandDetailResponse> detail(@NotBlank(message = "销售员（转介人）唯一标识(业务ID)不能为空") @RequestParam(value = "userSaleBizId") String userSaleBizId);

    /**
     * 添加销售员（转介人）
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiUserSaleExpandAddRequest request);

    /**
     * 编辑销售员（转介人）
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiUserSaleExpandEditRequest request);


    /**
     * 删除销售员（转介人）（逻辑删除）
     * @param userSaleBizId 销售员（转介人）唯一标识(业务ID)
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "userSaleBizId") String userSaleBizId);

    /**
     * 编辑销售员（转介人）状态
     * @param userSaleBizId 销售员（转介人）唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @PatchMapping("/edit/status")
    Result editStatus(@NotBlank(message = "销售员（转介人）唯一标识(业务ID)不能为空") @RequestParam(value = "userSaleBizId") String userSaleBizId,
                      @NotNull(message = "状态不能为空") @RequestParam(value = "status") Integer status);

}
