package com.yd.insurance.base.service.utils;

import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;

public class MyBatisPlusCodeGenerator {
    public static void main(String[] args) {
        FastAutoGenerator.create("jdbc:mysql://139.224.145.34:3308/yd_insurance_base?serverTimezone=GMT%2B8", "root", "Zxm7320017")
                .globalConfig(builder -> {
                    builder.author("zxm")
                            .outputDir("src/main/java/com/yd/user/service");
//                            .outputDir("D:/soft/ideaproject/v2/yd-insurance-base/yd-insurance-base-service/src/main/java");
                })
                .packageConfig(builder -> {
                    builder.parent("com.yd.insurance.base.service")
                            .entity("model")
                            .mapper("dao")
                            .service("service")
                            .serviceImpl("service.impl")
                            .xml("mappers");
                })
                .strategyConfig(builder -> {
                    builder.addInclude(
                            "insurance_category","insurance_company","insurance_company_contact",
                            "insurance_company_claim","insurance_company_payment","insurance_company_material",
                            "insurance_company_website"
                    )
                            .entityBuilder()
                            .enableLombok()
                            .enableTableFieldAnnotation()
                            .controllerBuilder()
                            .enableRestStyle();
                })
                .templateEngine(new FreemarkerTemplateEngine())
                .execute();
    }
}

