package com.yd.insurance.base.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 组织架构-用户关系表（多对多关系）
 * </p>
 *
 * @author zxm
 * @since 2025-08-25
 */
@Getter
@Setter
@TableName("rel_insurance_product_company")
public class RelInsuranceProductCompany implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 租户ID（业务id）(冗余字段，目的当前关系是发生在哪个作用域下：租户级)
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 项目ID（业务id）(冗余字段，目的当前关系是发生在哪个作用域下：项目级)
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 组织架构唯一业务ID
     */
    @TableField("dept_biz_id")
    private String deptBizId;

    /**
     * 用户唯一业务ID
     */
    @TableField("user_biz_id")
    private String userBizId;

    /**
     * 状态(0:禁用 1:启用)
     */
    @TableField("status")
    private Byte status;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Boolean isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
