package com.yd.insurance.base.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class InsuranceProductDto {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 保险产品唯一标识(业务ID)
     */
    private String productBizId;

    /**
     * 保险产品唯一标识(业务ID)集合
     */
    private List<String> productBizIdList;

    /**
     * 保险产品名称
     */
    private String productName;

    /**
     * 查询是否排除当前保险产品唯一标识数据，默认false不排除，true的话productBizId必传
     */
    @Builder.Default
    private Boolean isExcludeMy = false;
}
