package com.yd.insurance.base.feign.response;

import lombok.Data;
import java.math.BigDecimal;

@Data
public class ApiInsuranceProductPageResponse {

    /**
     * 保险产品主键id
     */
    private Long id;

    /**
     * 保险产品唯一业务ID
     */
    private String productBizId;

    /**
     * 保险产品名称
     */
    private String productName;

    /**
     * 保险产品类型
     */
    private String productType;

    /**
     * 支持货币
     */
    private String currency;

    /**
     * 供款年期
     */
    private String paymentTerm;

    /**
     * 受保年龄范围
     */
    private String insuredAgeRange;

    /**
     * 是否区分吸烟：0=不区分，1=区分
     */
    private Integer smokingAllowed;

    /**
     * 保障内容
     */
    private String coverageContent;

    /**
     * 基础费率
     */
    private BigDecimal premiumRate;

    /**
     * 保险产品状态：0=下架，1=在售
     */
    private Integer productStatus;

    /**
     * 作用域(1:系统级（全局） 2:租户级 3:项目级)
     */
    private Integer scope;

    /**
     * 所属租户ID（业务id）
     */
    private String tenantBizId;

    /**
     * 所属租户名称
     */
    private String tenantName;

    /**
     * 所属项目ID（业务id）
     */
    private String projectBizId;

    /**
     * 所属项目名称
     */
    private String projectName;

    /**
     * 产品图片
     */
    private String picture;

}
