package com.yd.insurance.base.feign.response;

import lombok.Data;
import java.math.BigDecimal;

@Data
public class ApiInsuranceAdditionalProductPageResponse {

    /**
     * 保险附加产品主键id
     */
    private Long id;

    /**
     * 保险附加产品唯一业务ID
     */
    private String additionalProductBizId;

    /**
     * 保险附加产品名称
     */
    private String productName;

    /**
     * 保险附加产品类型
     */
    private String productType;

    /**
     * 支持货币
     */
    private String currency;

    /**
     * 供款年期
     */
    private String paymentTerm;

    /**
     * 受保年龄范围
     */
    private String insuredAgeRange;

    /**
     * 是否区分吸烟：0=不区分，1=区分
     */
    private Integer smokingAllowed;

    /**
     * 保障内容
     */
    private String coverageContent;

    /**
     * 基础费率
     */
    private BigDecimal premiumRate;

    /**
     * 保险附加产品状态：0=下架，1=在售
     */
    private Integer productStatus;

    /**
     * 附加产品图片
     */
    private String picture;
}
