package com.yd.insurance.base.api.service.impl;

import com.yd.common.result.Result;
import com.yd.insurance.base.api.service.ApiRelInsuranceAdditionalProductService;
import com.yd.insurance.base.feign.dto.InsuranceAdditionalProductDto;
import com.yd.insurance.base.service.dto.RelInsuranceAdditionalProductDto;
import com.yd.insurance.base.service.model.InsuranceAdditionalProduct;
import com.yd.insurance.base.service.model.RelInsuranceAdditionalProduct;
import com.yd.insurance.base.service.service.IInsuranceAdditionalProductService;
import com.yd.insurance.base.service.service.IRelInsuranceAdditionalProductService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class ApiRelInsuranceAdditionalProductServiceImpl implements ApiRelInsuranceAdditionalProductService {

    @Autowired
    private IRelInsuranceAdditionalProductService iRelInsuranceAdditionalProductService;

    @Autowired
    private IInsuranceAdditionalProductService iInsuranceAdditionalProductService;

    /**
     * 更新保险产品和保险附加产品列表的关系数据（先删后增加）
     * @param productBizId
     * @param additionalProductBizIdList
     * @return
     */
    @Override
    public Result updateRelInsuranceAdditionalProductList(String productBizId,
                                                          List<String> additionalProductBizIdList) {
        //先删后增加
        iRelInsuranceAdditionalProductService.removeByProductBizId(productBizId);

        List<RelInsuranceAdditionalProduct> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(additionalProductBizIdList)) {
            //保险附加产品唯一标识(业务ID) 列表（选中列表）不为空
            list = additionalProductBizIdList.stream().map(bizId -> {
                RelInsuranceAdditionalProduct insuranceAdditionalProduct = new RelInsuranceAdditionalProduct();
                insuranceAdditionalProduct.setProductBizId(productBizId);
                insuranceAdditionalProduct.setAdditionalProductBizId(bizId);
                return insuranceAdditionalProduct;
            }).collect(Collectors.toList());

            iRelInsuranceAdditionalProductService.saveOrUpdateBatch(list);
        }
        return Result.success();
    }

    /**
     * 根据产品id获取保险附加产品集合
     * @param productBizId
     * @return
     */
    @Override
    public Result<List<InsuranceAdditionalProductDto>> getInsuranceAdditionalProductDtoList(String productBizId) {
        List<InsuranceAdditionalProductDto> insuranceAdditionalProductDtoList = new ArrayList<>();
        List<RelInsuranceAdditionalProduct> list = iRelInsuranceAdditionalProductService.queryList(RelInsuranceAdditionalProductDto.builder().productBizId(productBizId).build());

        if (!CollectionUtils.isEmpty(list)) {
            List<String> additionalProductBizIdList = list.stream().map(RelInsuranceAdditionalProduct::getAdditionalProductBizId).collect(Collectors.toList());
            List<InsuranceAdditionalProduct> insuranceAdditionalProductList = iInsuranceAdditionalProductService.queryList(com.yd.insurance.base.service.dto.InsuranceAdditionalProductDto.builder()
                    .additionalProductBizIdList(additionalProductBizIdList)
                    .build());
            if (!CollectionUtils.isEmpty(insuranceAdditionalProductList)) {
                insuranceAdditionalProductDtoList = insuranceAdditionalProductList.stream().map(dto -> {
                    InsuranceAdditionalProductDto insuranceAdditionalProductDto = new InsuranceAdditionalProductDto();
                    BeanUtils.copyProperties(dto,insuranceAdditionalProductDto);
                    return insuranceAdditionalProductDto;
                }).collect(Collectors.toList());
            }
        }
        return Result.success(insuranceAdditionalProductDtoList);
    }
}
